/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.parser.analyzer;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.w3c.css.parser.AtRule;
import org.w3c.css.parser.AtRuleFontFace;
import org.w3c.css.parser.AtRuleMedia;
import org.w3c.css.parser.AtRulePage;
import org.w3c.css.parser.AtRulePhoneticAlphabet;
import org.w3c.css.parser.AtRulePreference;
import org.w3c.css.parser.CssError;
import org.w3c.css.parser.CssParseException;
import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.analyzer.CommentSkipperInputStream;
import org.w3c.css.parser.analyzer.CssParserConstants;
import org.w3c.css.parser.analyzer.CssParserTokenManager;
import org.w3c.css.parser.analyzer.ParseException;
import org.w3c.css.parser.analyzer.SimpleCharStream;
import org.w3c.css.parser.analyzer.Token;
import org.w3c.css.parser.analyzer.TokenMgrError;
import org.w3c.css.properties.css1.CssProperty;
import org.w3c.css.properties.svg.AtRuleColorProfile;
import org.w3c.css.selectors.AdjacentSelector;
import org.w3c.css.selectors.AttributeSelector;
import org.w3c.css.selectors.ChildSelector;
import org.w3c.css.selectors.ClassSelector;
import org.w3c.css.selectors.DescendantSelector;
import org.w3c.css.selectors.IdSelector;
import org.w3c.css.selectors.TypeSelector;
import org.w3c.css.selectors.UniversalSelector;
import org.w3c.css.selectors.attributes.AttributeAny;
import org.w3c.css.selectors.attributes.AttributeBegin;
import org.w3c.css.selectors.attributes.AttributeExact;
import org.w3c.css.selectors.attributes.AttributeOneOf;
import org.w3c.css.selectors.attributes.AttributeStart;
import org.w3c.css.selectors.attributes.AttributeSubstr;
import org.w3c.css.selectors.attributes.AttributeSuffix;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.util.Util;
import org.w3c.css.values.ATSCColor;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssColor;
import org.w3c.css.values.CssDate;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssResolution;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssURL;
import org.w3c.css.values.CssUnicodeRange;
import org.w3c.css.values.CssValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CssParser
implements CssParserConstants {
    private static char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    protected AtRule atRule;
    protected String mediaDeclaration = "off";
    protected URL url;
    protected ApplContext ac;
    protected boolean incompatible_error;
    protected Vector currentContext;
    protected String currentProperty;
    protected boolean mode;
    protected boolean markRule;
    static StringBuffer SPACE = new StringBuffer(" ");
    protected boolean validSelector = true;
    public CssParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[111];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;

    public final void setApplContext(ApplContext ac) {
        this.ac = ac;
    }

    public void setAtRule(AtRule atRule) {
        this.atRule = atRule;
    }

    public void setMediaDeclaration(String mediadeclaration) {
        this.mediaDeclaration = mediadeclaration;
    }

    public String getMediaDeclaration() {
        return this.mediaDeclaration;
    }

    public AtRule getAtRule() {
        return this.atRule;
    }

    public void ReInitWithAc(InputStream stream, ApplContext ac) {
        this.ReInit(new CommentSkipperInputStream(stream));
        this.markRule = false;
        this.setApplContext(ac);
    }

    public abstract void handleImport(URL var1, String var2, AtRuleMedia var3);

    public abstract void handleAtRule(String var1, String var2);

    public abstract void addCharSet(String var1);

    public abstract void newAtRule(AtRule var1);

    public abstract void endOfAtRule();

    public abstract void setImportant(boolean var1);

    public abstract void setSelectorList(Vector var1);

    public abstract void addProperty(Vector var1);

    public abstract void endOfRule();

    public abstract void removeThisRule();

    public abstract void removeThisAtRule();

    public abstract CssProperty handleDeclaration(String var1, CssExpression var2, boolean var3) throws InvalidParamException;

    public abstract void handleRule(CssSelectors var1, Vector var2);

    public final String getSourceFile() {
        return this.getURL().toString();
    }

    public final int getLine() {
        return 0;
    }

    public final void setURL(URL url) {
        this.url = url;
    }

    public final URL getURL() {
        return this.url;
    }

    public CssSelectors parseSelector() throws ParseException {
        return this.externalSelector();
    }

    private void setValue(CssValue v, CssExpression expr, char operator, Token n, int token) throws ParseException {
        if (n != null) {
            String val;
            if (this.ac.getCssVersion().equals("css1") && n.image.equals("inherit")) {
                this.incompatible_error = true;
            }
            String string = val = operator == ' ' ? n.image : operator + n.image;
            if (n.kind == 34) {
                v.set(this.convertIdent(val), this.ac);
            } else if (n.kind == 32) {
                v.set(val, this.ac);
            } else {
                v.set(val, this.ac);
            }
        }
        expr.addValue(v);
    }

    private void addError(Exception e, String skippedText) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setSkippedString(skippedText);
        ex.setProperty(this.currentProperty);
        ex.setContexts(this.currentContext);
        CssError error = new CssError(this.getSourceFile(), this.getLine(), ex);
        this.ac.getFrame().addError(error);
    }

    private void addError(Exception e, CssExpression exp) {
        if (Util.onDebug) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        CssParseException ex = new CssParseException(e);
        ex.setExp(exp);
        ex.setProperty(this.currentProperty);
        ex.setContexts(this.currentContext);
        CssError error = new CssError(this.getSourceFile(), this.getLine(), ex);
        this.ac.getFrame().addError(error);
    }

    public final void parserUnit() throws ParseException {
        Token n = null;
        try {
            block26: {
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 93: 
                        case 94: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block23;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 93: {
                            n = this.jj_consume_token(93);
                            break;
                        }
                        case 94: {
                            n = this.jj_consume_token(94);
                            break;
                        }
                        default: {
                            this.jj_la1[1] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    this.addError((Exception)new ParseException(this.ac.getMsg().getString("generator.dontmixhtml")), n.image);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 66: {
                        this.charset();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                block24: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: 
                        case 22: 
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[3] = this.jj_gen;
                            break block26;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            this.jj_consume_token(21);
                            continue block24;
                        }
                        case 22: {
                            this.jj_consume_token(22);
                            continue block24;
                        }
                        case 23: {
                            this.jj_consume_token(23);
                            continue block24;
                        }
                    }
                    break;
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            block25: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 67: {
                        break;
                    }
                    default: {
                        this.jj_la1[5] = this.jj_gen;
                        break block25;
                    }
                }
                this.importDeclaration();
                this.ignoreStatement();
            }
            this.afterImportDeclaration();
        }
        catch (TokenMgrError err) {
            this.addError((Exception)new ParseException(this.ac.getMsg().getString("generator.unrecognize")), err.getMessage());
        }
        this.jj_consume_token(0);
    }

    public final void charset() throws ParseException {
        Token n = null;
        Token charsetToken = null;
        Token space1Token = null;
        Token space2Token = null;
        Token semicolonToken = null;
        int nb_S = 0;
        try {
            charsetToken = this.jj_consume_token(66);
            block8: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[6] = this.jj_gen;
                        break block8;
                    }
                }
                space1Token = this.jj_consume_token(21);
                ++nb_S;
            }
            n = this.jj_consume_token(32);
            block9: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[7] = this.jj_gen;
                        break block9;
                    }
                }
                space2Token = this.jj_consume_token(21);
            }
            semicolonToken = this.jj_consume_token(42);
            if (charsetToken.beginLine != 1 || charsetToken.beginColumn != 1) {
                throw new ParseException(this.ac.getMsg().getString("parser.charset"));
            }
            if ("css21".equals(this.ac.getCssVersion()) && (nb_S != 1 || !"@charset".equals(charsetToken.image) || !" ".equals(space1Token.image) || space2Token != null && !"".equals(space2Token.image) || space1Token.specialToken != null || n.specialToken != null || semicolonToken.specialToken != null || n.image.charAt(0) != '\"')) {
                throw new ParseException(this.ac.getMsg().getString("parser.charsetspecial"));
            }
            this.addCharSet(n.image);
        }
        catch (Exception e) {
            String skip = charsetToken + (space1Token == null ? "" : space1Token.image) + n + (space2Token == null ? "" : space2Token.image) + ";";
            this.addError(e, skip);
        }
    }

    public final void afterImportDeclaration() throws ParseException {
        while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: 
                case 35: 
                case 44: 
                case 46: 
                case 47: 
                case 50: 
                case 65: 
                case 90: {
                    this.ruleSet();
                    break;
                }
                case 68: {
                    this.media();
                    break;
                }
                case 69: {
                    this.page();
                    break;
                }
                case 70: {
                    this.fontFace();
                    break;
                }
                case 71: {
                    this.preference();
                    break;
                }
                case 72: {
                    this.colorprofile();
                    break;
                }
                case 78: {
                    this.phoneticAlphabet();
                    break;
                }
                default: {
                    ParseException e;
                    this.jj_la1[8] = this.jj_gen;
                    String ret = this.skipStatement();
                    if (ret == null || ret.length() == 0) {
                        return;
                    }
                    if (ret.startsWith("@charset")) {
                        e = new ParseException(this.ac.getMsg().getString("parser.charset"));
                        this.addError((Exception)e, ret);
                        break;
                    }
                    e = new ParseException(this.ac.getMsg().getString("generator.unrecognize"));
                    this.addError((Exception)e, ret);
                }
            }
            this.ignoreStatement();
        }
    }

    public final void ignoreStatement() throws ParseException {
        block11: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: 
                case 23: 
                case 79: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    this.jj_consume_token(22);
                    break;
                }
                case 23: {
                    this.jj_consume_token(23);
                    break;
                }
                case 79: {
                    this.atRuleDeclaration();
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                        continue block11;
                    }
                }
                this.jj_consume_token(21);
            }
            break;
        }
    }

    public final void importDeclaration() throws ParseException {
        AtRuleMedia media = new AtRuleMedia();
        try {
            String importFile;
            this.jj_consume_token(67);
            block24: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                        break block24;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 32: {
                    Token n = this.jj_consume_token(32);
                    importFile = n.image.substring(1, n.image.length() - 1);
                    break;
                }
                case 52: {
                    Token n = this.jj_consume_token(52);
                    CssURL val = new CssURL();
                    val.set(n.image, this.ac, this.url);
                    importFile = (String)((CssValue)val).get();
                    if (importFile.charAt(0) != '\"' && importFile.charAt(0) != '\'') break;
                    importFile = importFile.substring(1, importFile.length() - 1);
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block25: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                        break block25;
                    }
                }
                this.jj_consume_token(21);
            }
            block11 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    this.medium(media);
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 29: {
                                break;
                            }
                            default: {
                                this.jj_la1[15] = this.jj_gen;
                                break block11;
                            }
                        }
                        this.jj_consume_token(29);
                        block27: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[16] = this.jj_gen;
                                    break block27;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        this.medium(media);
                    }
                }
                default: {
                    this.jj_la1[17] = this.jj_gen;
                }
            }
            this.jj_consume_token(42);
            block28: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[18] = this.jj_gen;
                        break block28;
                    }
                }
                this.jj_consume_token(21);
            }
            this.handleImport(this.getURL(), importFile, media);
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void media() throws ParseException {
        AtRule old = this.getAtRule();
        AtRuleMedia newRule = new AtRuleMedia();
        this.setAtRule(newRule);
        CssProperty p = null;
        try {
            this.jj_consume_token(68);
            block41: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block41;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 51: {
                    Token n = this.jj_consume_token(51);
                    newRule.addMediaRestrictor(this.convertIdent(n.image), this.ac);
                    block42: while (true) {
                        this.jj_consume_token(21);
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                continue block42;
                            }
                        }
                        break;
                    }
                    this.jj_la1[20] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                }
            }
            this.medium(newRule);
            block43: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                        break block43;
                    }
                }
                this.jj_consume_token(29);
                block44: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[23] = this.jj_gen;
                            break block44;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.medium(newRule);
            }
            block45: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 31: {
                        break;
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                        break block45;
                    }
                }
                this.jj_consume_token(31);
                block46: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[25] = this.jj_gen;
                            break block46;
                        }
                    }
                    this.jj_consume_token(21);
                }
                this.jj_consume_token(49);
                block47: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block47;
                        }
                    }
                    this.jj_consume_token(21);
                }
                p = this.mediadeclaration();
                newRule.addMediaFeature(p);
                this.jj_consume_token(48);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[27] = this.jj_gen;
                            continue block45;
                        }
                    }
                    this.jj_consume_token(21);
                }
                break;
            }
            String media = this.getAtRule().toString();
            if (this.ac.getMedium() != null && !media.equals(this.ac.getMedium()) && !this.ac.getMedium().equals("all")) {
                this.ac.getFrame().addWarning("noothermedium", this.getAtRule().toString());
            }
            if (this.ac.getCssVersion().equals("css1")) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block49: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[28] = this.jj_gen;
                        break block49;
                    }
                }
                this.jj_consume_token(21);
            }
            block50: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: 
                    case 35: 
                    case 44: 
                    case 46: 
                    case 47: 
                    case 50: 
                    case 65: 
                    case 90: {
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                        break block50;
                    }
                }
                this.ruleSet();
            }
            this.jj_consume_token(36);
            block51: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                        break block51;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.endOfAtRule();
            }
        }
        catch (ParseException e) {
            if (!this.ac.getCssVersion().equals("css1")) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final void medium(AtRuleMedia media) throws ParseException {
        Token n = this.jj_consume_token(34);
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[31] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(21);
        }
        try {
            media.addMedia(this.convertIdent(n.image), this.ac);
        }
        catch (InvalidParamException e) {
            CssError error = new CssError(this.getSourceFile(), this.getLine(), e);
            this.ac.getFrame().addError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void page() throws ParseException {
        Token n = null;
        Vector collectv = new Vector();
        CssSelectors s = new CssSelectors(this.ac);
        AtRule old = this.getAtRule();
        AtRulePage newRule = new AtRulePage();
        this.setAtRule(newRule);
        s.setAtRule(this.getAtRule());
        try {
            Vector v;
            this.jj_consume_token(69);
            block25: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[32] = this.jj_gen;
                        break block25;
                    }
                }
                this.jj_consume_token(21);
            }
            block6 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    n = this.jj_consume_token(34);
                    newRule.setIdent(this.convertIdent(n.image));
                    while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[33] = this.jj_gen;
                                break block6;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                }
                default: {
                    this.jj_la1[34] = this.jj_gen;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 50: {
                    this.pseudo_page(newRule);
                    break;
                }
                default: {
                    this.jj_la1[35] = this.jj_gen;
                }
            }
            this.jj_consume_token(26);
            block27: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[36] = this.jj_gen;
                        break block27;
                    }
                }
                this.jj_consume_token(21);
            }
            collectv = v = this.pageContent();
            this.jj_consume_token(36);
            block28: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[37] = this.jj_gen;
                        break block28;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.newAtRule(this.getAtRule());
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.addProperty(collectv);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.handleRule(s, collectv);
            }
        }
        catch (InvalidParamException ie) {
            if (!this.ac.getCssVersion().equals("css1")) {
                this.skipStatement();
                this.removeThisAtRule();
                this.ac.getFrame().addError(new CssError(ie));
            }
        }
        catch (ParseException e) {
            if (!this.ac.getCssVersion().equals("css1")) {
                this.removeThisAtRule();
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final Vector pageContent() throws ParseException {
        Vector<CssProperty> v = new Vector<CssProperty>();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 73: 
            case 74: 
            case 75: 
            case 76: {
                v = this.prefAtRule();
                return v;
            }
        }
        this.jj_la1[38] = this.jj_gen;
        v = this.declarations();
        return v;
    }

    public final Vector prefAtRule() throws ParseException {
        try {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 73: {
                    Token n = this.jj_consume_token(73);
                    break;
                }
                case 75: {
                    Token n = this.jj_consume_token(75);
                    break;
                }
                case 76: {
                    Token n = this.jj_consume_token(76);
                    break;
                }
                case 74: {
                    Token n = this.jj_consume_token(74);
                    break;
                }
                default: {
                    this.jj_la1[39] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            this.jj_consume_token(26);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[41] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            Vector<CssProperty> v = this.declarations();
            this.jj_consume_token(36);
            block19: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                        break block19;
                    }
                }
                this.jj_consume_token(21);
            }
            return v;
        }
        catch (ParseException e) {
            this.addError((Exception)e, this.skipStatement());
            throw new Error("Missing return statement in function");
        }
    }

    public final void pseudo_page(AtRulePage page) throws ParseException {
        this.jj_consume_token(50);
        Token n = this.jj_consume_token(34);
        block5: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    break block5;
                }
            }
            this.jj_consume_token(21);
        }
        try {
            page.setName(":" + this.convertIdent(n.image), this.ac);
        }
        catch (InvalidParamException e) {
            throw new InvalidParamException("pseudo", n.image, this.ac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fontFace() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRuleFontFace());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        try {
            this.jj_consume_token(70);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[44] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (this.ac.getCssVersion().equals("css1")) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[45] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            Vector<CssProperty> v = this.declarations();
            this.jj_consume_token(36);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[46] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("no-declaration");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (!this.ac.getCssVersion().equals("css1")) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void colorprofile() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRuleColorProfile());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        try {
            this.jj_consume_token(72);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!this.ac.getCssVersion().equals("svg")) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("onlysvg", "", this.ac), this.getAtRule().toString());
            }
            if (this.ac.getCssVersion().equals("svg")) {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[48] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            Vector<CssProperty> v = this.declarations();
            this.jj_consume_token(36);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[49] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (this.ac.getCssVersion().equals("svg")) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (this.ac.getCssVersion().equals("svg")) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void preference() throws ParseException {
        AtRule old = this.getAtRule();
        this.setAtRule(new AtRulePreference());
        CssSelectors s = new CssSelectors(this.ac);
        s.setAtRule(this.getAtRule());
        try {
            this.jj_consume_token(71);
            block14: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[50] = this.jj_gen;
                        break block14;
                    }
                }
                this.jj_consume_token(21);
            }
            if (this.ac.getCssVersion().equals("css1")) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.newAtRule(this.getAtRule());
            }
            this.jj_consume_token(26);
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[51] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(21);
            }
            Vector<CssProperty> v = this.declarations();
            this.jj_consume_token(36);
            block16: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        break block16;
                    }
                }
                this.jj_consume_token(21);
            }
            if (!this.ac.getCssVersion().equals("css1")) {
                this.addProperty(v);
                this.endOfRule();
                this.endOfAtRule();
            }
            if (v == null) {
                this.ac.getFrame().addWarning("medialist");
            } else {
                this.handleRule(s, v);
            }
        }
        catch (ParseException e) {
            if (!this.ac.getCssVersion().equals("css1")) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void phoneticAlphabet() throws ParseException {
        AtRule old = this.getAtRule();
        AtRulePhoneticAlphabet alphabetrule = new AtRulePhoneticAlphabet();
        this.setAtRule(alphabetrule);
        try {
            this.jj_consume_token(78);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[53] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(21);
            }
            Token n = this.jj_consume_token(32);
            block12: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        break block12;
                    }
                }
                this.jj_consume_token(21);
            }
            this.jj_consume_token(42);
            if (!this.ac.getCssVersion().equals("css3")) {
                this.skipStatement();
                this.addError((Exception)new InvalidParamException("noatruleyet", "", this.ac), this.getAtRule().toString());
            }
            alphabetrule.addAlphabet(this.convertIdent(n.image), this.ac);
            if (!this.ac.getCssVersion().equals("css1") && !this.ac.getCssVersion().equals("css2")) {
                this.newAtRule(this.getAtRule());
            }
        }
        catch (ParseException e) {
            if (!this.ac.getCssVersion().equals("css1")) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        finally {
            this.setAtRule(old);
        }
    }

    public final void atRuleDeclaration() throws ParseException {
        Token n = this.jj_consume_token(79);
        this.ac.getFrame().addError(new CssError(new InvalidParamException("at-rule", this.token, this.ac)));
        this.skipStatement();
    }

    public final void operator(CssExpression expr) throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: 
            case 43: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 43: {
                        this.jj_consume_token(43);
                        if (expr.getCount() <= 0) break;
                        expr.setOperator('/');
                        break;
                    }
                    case 29: {
                        this.jj_consume_token(29);
                        if (expr.getCount() <= 0) break;
                        expr.setOperator(',');
                        break;
                    }
                    default: {
                        this.jj_la1[55] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[56] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
    }

    public final char combinator() throws ParseException {
        char connector = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 28: 
            case 30: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: {
                        this.jj_consume_token(27);
                        connector = '+';
                        break;
                    }
                    case 28: {
                        this.jj_consume_token(28);
                        connector = '>';
                        break;
                    }
                    case 30: {
                        this.jj_consume_token(30);
                        connector = '~';
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[59] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            case 21: {
                block16: while (true) {
                    this.jj_consume_token(21);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            continue block16;
                        }
                    }
                    break;
                }
                this.jj_la1[60] = this.jj_gen;
                connector = ' ';
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return connector;
    }

    public final char unaryOperator() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 41: {
                this.jj_consume_token(41);
                return '-';
            }
            case 27: {
                this.jj_consume_token(27);
                return '+';
            }
        }
        this.jj_la1[62] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String property() throws ParseException {
        Token n = this.jj_consume_token(34);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[63] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        this.currentProperty = this.convertIdent(n.image);
        return this.currentProperty;
    }

    public final void ruleSet() throws ParseException {
        Vector<CssSelectors> context_set = new Vector<CssSelectors>();
        Vector<CssProperty> value_set = null;
        this.currentContext = context_set;
        try {
            CssSelectors contextual = this.selector();
            if (contextual != null) {
                context_set.addElement(contextual);
            }
            block15: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 29: {
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                        break block15;
                    }
                }
                this.jj_consume_token(29);
                block16: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[65] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.jj_consume_token(21);
                }
                contextual = this.selector();
                if (contextual == null) continue;
                context_set.addElement(contextual);
            }
            this.jj_consume_token(26);
            block17: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        break block17;
                    }
                }
                this.jj_consume_token(21);
            }
            value_set = this.declarations();
            this.jj_consume_token(36);
            block18: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[67] = this.jj_gen;
                        break block18;
                    }
                }
                this.jj_consume_token(21);
            }
            this.markRule = true;
            if (value_set != null) {
                boolean first = true;
                CssSelectors sel = null;
                Enumeration e = context_set.elements();
                while (e.hasMoreElements()) {
                    sel = (CssSelectors)e.nextElement();
                    if (first) {
                        this.handleRule(sel, value_set);
                        first = false;
                        continue;
                    }
                    int vsize = value_set.size();
                    Vector<CssProperty> v = new Vector<CssProperty>(vsize);
                    for (int i = 0; i < vsize; ++i) {
                        v.addElement(value_set.elementAt(i).duplicate());
                    }
                    this.handleRule(sel, v);
                }
                this.setSelectorList(context_set);
                this.endOfRule();
            }
            this.currentContext = null;
        }
        catch (ParseException e) {
            if (this.ac.getProfile() != null && !this.ac.getProfile().equals("mobile") && !context_set.isEmpty()) {
                this.addError((Exception)e, this.skipStatement());
            }
        }
        catch (TokenMgrError e) {
            this.addError((Exception)new ParseException(e.getMessage()), this.skipStatement());
        }
    }

    public final Vector<CssProperty> declarations() throws ParseException {
        CssProperty values;
        if (!this.validSelector) {
            this.validSelector = true;
            this.skip_to_matching_brace();
            return null;
        }
        Vector<CssProperty> value_set = new Vector<CssProperty>();
        boolean wrong_value = true;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                values = this.declaration();
                if (values != null) {
                    value_set.addElement(values);
                    wrong_value = false;
                }
                this.currentProperty = null;
                break;
            }
            default: {
                this.jj_la1[68] = this.jj_gen;
            }
        }
        block12: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 42: {
                    break;
                }
                default: {
                    this.jj_la1[69] = this.jj_gen;
                    break block12;
                }
            }
            this.jj_consume_token(42);
            block13: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        break;
                    }
                    default: {
                        this.jj_la1[70] = this.jj_gen;
                        break block13;
                    }
                }
                this.jj_consume_token(21);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 34: {
                    values = this.declaration();
                    if (values != null) {
                        value_set.addElement(values);
                        wrong_value = false;
                    }
                    this.currentProperty = null;
                    continue block12;
                }
            }
            this.jj_la1[71] = this.jj_gen;
        }
        if (!wrong_value) {
            this.addProperty(value_set);
            return value_set;
        }
        return null;
    }

    public final CssSelectors selector() throws ParseException {
        try {
            CssSelectors current = this.simple_selector(null);
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: 
                    case 27: 
                    case 28: 
                    case 30: {
                        break;
                    }
                    default: {
                        this.jj_la1[72] = this.jj_gen;
                        break block10;
                    }
                }
                char comb = this.combinator();
                if (this.ac.getProfile() != null) {
                    if (this.ac.getProfile().equals("mobile") || this.getAtRule().toString().equals("@media atsc-tv") || this.ac.getCssVersion().equals("css1")) {
                        if (comb == '+') {
                            throw new InvalidParamException("nocomb", "+", this.ac);
                        }
                        if (comb == '>') {
                            throw new InvalidParamException("nocomb", ">", this.ac);
                        }
                    } else if (this.ac.getProfile().equals("tv") && comb == '+') {
                        throw new InvalidParamException("nocomb", "+", this.ac);
                    }
                }
                if (!this.ac.getCssVersion().equals("css3") && comb == '~') {
                    throw new InvalidParamException("nocomb", "~", this.ac);
                }
                switch (comb) {
                    case '+': {
                        current.addAdjacent(new AdjacentSelector());
                        break;
                    }
                    case '>': {
                        current.addChild(new ChildSelector());
                        break;
                    }
                    default: {
                        current.addDescendant(new DescendantSelector());
                    }
                }
                current = this.simple_selector(current);
            }
            return current;
        }
        catch (InvalidParamException ie) {
            this.skipStatement();
            this.removeThisRule();
            this.ac.getFrame().addError(new CssError(ie));
            return null;
        }
        catch (ParseException e) {
            this.validSelector = false;
            if (this.ac.getProfile() != null) {
                if (!this.ac.getProfile().equals("mobile")) {
                    Token t = this.getToken(1);
                    StringBuffer s = new StringBuffer();
                    s.append(this.getToken((int)0).image);
                    while (t.kind != 29 && t.kind != 26 && t.kind != 0) {
                        s.append(t.image);
                        this.getNextToken();
                        t = this.getToken(1);
                    }
                    this.addError((Exception)e, s.toString());
                    return null;
                }
            } else {
                Token t = this.getToken(1);
                StringBuffer s = new StringBuffer();
                s.append(this.getToken((int)0).image);
                while (t.kind != 29 && t.kind != 26 && t.kind != 0) {
                    s.append(t.image);
                    this.getNextToken();
                    t = this.getToken(1);
                }
                this.addError((Exception)e, s.toString());
                return null;
            }
            throw new Error("Missing return statement in function");
        }
    }

    public final CssSelectors externalSelector() throws ParseException {
        CssSelectors current = this.simple_selector(null);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    break block6;
                }
            }
            block7: while (true) {
                this.jj_consume_token(21);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 21: {
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[74] = this.jj_gen;
            current = this.simple_selector(current);
        }
        return current;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final CssSelectors simple_selector(CssSelectors next) throws ParseException {
        CssSelectors selector = new CssSelectors(this.ac, next);
        selector.setAtRule(this.getAtRule());
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: 
            case 46: {
                this.element_name(selector);
                block22: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 44: 
                        case 47: 
                        case 50: 
                        case 65: 
                        case 90: {
                            break;
                        }
                        default: {
                            this.jj_la1[75] = this.jj_gen;
                            return selector;
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            this.hash(selector);
                            continue block22;
                        }
                        case 47: 
                        case 90: {
                            this._class(selector);
                            continue block22;
                        }
                        case 44: {
                            this.attrib(selector);
                            continue block22;
                        }
                        case 50: 
                        case 65: {
                            this.pseudo(selector);
                            continue block22;
                        }
                    }
                    break;
                }
                this.jj_la1[76] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 35: 
            case 44: 
            case 47: 
            case 50: 
            case 65: 
            case 90: {
                block23: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: {
                            this.hash(selector);
                            break;
                        }
                        case 47: 
                        case 90: {
                            this._class(selector);
                            break;
                        }
                        case 44: {
                            this.attrib(selector);
                            break;
                        }
                        case 50: 
                        case 65: {
                            this.pseudo(selector);
                            break;
                        }
                        default: {
                            this.jj_la1[77] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 35: 
                        case 44: 
                        case 47: 
                        case 50: 
                        case 65: 
                        case 90: {
                            continue block23;
                        }
                    }
                    break;
                }
                this.jj_la1[78] = this.jj_gen;
                return selector;
            }
        }
        this.jj_la1[79] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void _class(CssSelectors s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 90: {
                Token n = this.jj_consume_token(90);
                try {
                    s.addClass(new ClassSelector(this.convertClassIdent(n.image.substring(1))));
                }
                catch (InvalidParamException e) {
                    this.removeThisRule();
                    this.ac.getFrame().addError(new CssError(e));
                }
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                Token n = this.deprecated_class();
                if (n.image.charAt(0) == '.') {
                    n.image = n.image.substring(1);
                    String cl = "\\" + Integer.toString(n.image.charAt(0), 16);
                    cl = cl + n.image.substring(1);
                    String profile = this.ac.getProfile();
                    if (profile == null || profile.equals("") || profile.equals("none")) {
                        profile = this.ac.getCssVersion();
                    }
                    if (!profile.equals("css1")) {
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.old_class")), "To make \"." + n.image + "\" a valid class, CSS2" + " requires the first digit to be escaped " + "(\"." + cl + "\")");
                        s.addClass(new ClassSelector(n.image));
                        this.removeThisRule();
                        break;
                    }
                    CssLength length = new CssLength();
                    boolean isLength = false;
                    try {
                        length.set(n.image, this.ac);
                        isLength = true;
                    }
                    catch (Exception e) {
                        isLength = false;
                    }
                    if (isLength) {
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.class_dim")), n.image);
                        s.addClass(new ClassSelector(n.image));
                        this.removeThisRule();
                        break;
                    }
                    try {
                        s.addClass(new ClassSelector(n.image));
                        this.ac.getFrame().addWarning("old_class");
                    }
                    catch (InvalidParamException e) {
                        this.ac.getFrame().addError(new CssError(e));
                        this.removeThisRule();
                    }
                    break;
                }
                throw new ParseException("Unrecognized ");
            }
            default: {
                this.jj_la1[80] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final Token deprecated_class() throws ParseException {
        Token n;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 53: {
                n = this.jj_consume_token(53);
                break;
            }
            case 54: {
                n = this.jj_consume_token(54);
                break;
            }
            case 55: {
                n = this.jj_consume_token(55);
                break;
            }
            case 56: {
                n = this.jj_consume_token(56);
                break;
            }
            case 57: {
                n = this.jj_consume_token(57);
                break;
            }
            case 58: {
                n = this.jj_consume_token(58);
                break;
            }
            case 59: {
                n = this.jj_consume_token(59);
                break;
            }
            case 61: {
                n = this.jj_consume_token(61);
                break;
            }
            default: {
                this.jj_la1[81] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return n;
    }

    public final void element_name(CssSelectors s) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 34: {
                Token n = this.jj_consume_token(34);
                s.addType(new TypeSelector(this.convertIdent(n.image)));
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                if (!this.ac.getCssVersion().equals("css1")) {
                    s.addUniversal(new UniversalSelector());
                    break;
                }
                this.ac.getFrame().addError(new CssError(new InvalidParamException("notversion", "*", this.ac.getCssVersion(), this.ac)));
                break;
            }
            default: {
                this.jj_la1[82] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void attrib(CssSelectors s) throws ParseException {
        Token att = null;
        Token val = null;
        int selectorType = -1;
        this.jj_consume_token(44);
        block39: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[83] = this.jj_gen;
                    break block39;
                }
            }
            this.jj_consume_token(21);
        }
        att = this.jj_consume_token(34);
        block40: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[84] = this.jj_gen;
                    break block40;
                }
            }
            this.jj_consume_token(21);
        }
        block8 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 24: 
            case 25: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 40: {
                        this.jj_consume_token(40);
                        selectorType = 32;
                        break;
                    }
                    case 24: {
                        this.jj_consume_token(24);
                        selectorType = 126;
                        break;
                    }
                    case 25: {
                        this.jj_consume_token(25);
                        selectorType = 124;
                        break;
                    }
                    case 37: {
                        this.jj_consume_token(37);
                        selectorType = 94;
                        break;
                    }
                    case 38: {
                        this.jj_consume_token(38);
                        selectorType = 36;
                        break;
                    }
                    case 39: {
                        this.jj_consume_token(39);
                        selectorType = 42;
                        break;
                    }
                    default: {
                        this.jj_la1[85] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                block41: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[86] = this.jj_gen;
                            break block41;
                        }
                    }
                    this.jj_consume_token(21);
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        val = this.jj_consume_token(34);
                        val.image = this.convertIdent(val.image);
                        break block8;
                    }
                    case 32: {
                        val = this.jj_consume_token(32);
                        val.image = this.convertStringIndex(val.image, 1, val.image.length() - 1, false);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[87] = this.jj_gen;
                                    break block8;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                    }
                }
                this.jj_la1[88] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[89] = this.jj_gen;
            }
        }
        this.jj_consume_token(45);
        if (selectorType == -1) {
            try {
                s.addAttribute(new AttributeAny(att.image.toLowerCase()));
            }
            catch (InvalidParamException e) {
                this.removeThisRule();
                this.ac.getFrame().addError(new CssError(e));
            }
        } else {
            AttributeSelector attribute;
            switch (selectorType) {
                case 124: {
                    attribute = new AttributeBegin(att.image.toLowerCase(), val.image);
                    break;
                }
                case 32: {
                    attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                    break;
                }
                case 126: {
                    attribute = new AttributeOneOf(att.image.toLowerCase(), val.image);
                    break;
                }
                case 94: {
                    attribute = new AttributeStart(att.image.toLowerCase(), val.image);
                    break;
                }
                case 42: {
                    attribute = new AttributeSubstr(att.image.toLowerCase(), val.image);
                    break;
                }
                case 36: {
                    attribute = new AttributeSuffix(att.image.toLowerCase(), val.image);
                    break;
                }
                default: {
                    attribute = new AttributeExact(att.image.toLowerCase(), val.image);
                }
            }
            try {
                s.addAttribute(attribute);
            }
            catch (InvalidParamException e) {
                this.removeThisRule();
                this.ac.getFrame().addError(new CssError(e));
            }
        }
    }

    public final void pseudo(CssSelectors s) throws ParseException {
        Token language = null;
        CssSelectors param = null;
        block4 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 65: {
                this.jj_consume_token(65);
                Token n = this.jj_consume_token(34);
                try {
                    if (!this.ac.getCssVersion().equals("css3")) {
                        throw new InvalidParamException("pseudo-element", ":" + this.convertIdent(n.image).toLowerCase(), this.ac.getCssVersion(), this.ac);
                    }
                    s.addPseudo(this.convertIdent(n.image).toLowerCase());
                }
                catch (InvalidParamException e) {
                    this.removeThisRule();
                    this.ac.getFrame().addError(new CssError(e));
                }
                break;
            }
            case 50: {
                this.jj_consume_token(50);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 34: {
                        Token n = this.jj_consume_token(34);
                        try {
                            s.addPseudo(this.convertIdent(n.image).toLowerCase());
                        }
                        catch (InvalidParamException e) {
                            this.removeThisRule();
                            this.ac.getFrame().addError(new CssError(e));
                        }
                        break block4;
                    }
                    case 91: 
                    case 92: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 91: {
                                Token n = this.jj_consume_token(91);
                                block34: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 21: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[90] = this.jj_gen;
                                            break block34;
                                        }
                                    }
                                    this.jj_consume_token(21);
                                }
                                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                    case 63: {
                                        language = this.jj_consume_token(63);
                                        break;
                                    }
                                    case 34: {
                                        language = this.jj_consume_token(34);
                                        break;
                                    }
                                    case 32: {
                                        language = this.jj_consume_token(32);
                                        break;
                                    }
                                    default: {
                                        this.jj_la1[91] = this.jj_gen;
                                        this.jj_consume_token(-1);
                                        throw new ParseException();
                                    }
                                }
                                try {
                                    s.setPseudoFun(this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), this.convertIdent(language.image));
                                }
                                catch (InvalidParamException e) {
                                    this.removeThisRule();
                                    this.ac.getFrame().addError(new CssError(e));
                                }
                                break;
                            }
                            case 92: {
                                Token n = this.jj_consume_token(92);
                                block35: while (true) {
                                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                        case 21: {
                                            break;
                                        }
                                        default: {
                                            this.jj_la1[92] = this.jj_gen;
                                            break block35;
                                        }
                                    }
                                    this.jj_consume_token(21);
                                }
                                param = this.simple_selector(null);
                                try {
                                    s.setPseudoFun(this.convertStringIndex(n.image, 0, n.image.length() - 1, false).toLowerCase(), param.toString());
                                }
                                catch (InvalidParamException e) {
                                    this.removeThisRule();
                                    this.ac.getFrame().addError(new CssError(e));
                                }
                                break;
                            }
                            default: {
                                this.jj_la1[93] = this.jj_gen;
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        block36: while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[94] = this.jj_gen;
                                    break block36;
                                }
                            }
                            this.jj_consume_token(21);
                        }
                        this.jj_consume_token(48);
                        break block4;
                    }
                }
                this.jj_la1[95] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[96] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void hash(CssSelectors s) throws ParseException {
        Token n = this.jj_consume_token(35);
        n.image = n.image.substring(1);
        if (Character.isDigit(n.image.charAt(0))) {
            String profile = this.ac.getProfile();
            if (profile == null || profile.equals("") || profile.equals("none")) {
                profile = this.ac.getCssVersion();
            }
            if (!profile.equals("css1")) {
                String cl = "\\" + Integer.toString(n.image.charAt(0), 16);
                cl = cl + n.image.substring(1);
                this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.old_id")), "To make \"." + n.image + "\" a valid id, CSS2" + " requires the first digit to be escaped " + "(\"#" + cl + "\")");
                s.addId(new IdSelector(n.image));
                this.removeThisRule();
            } else {
                CssLength length = new CssLength();
                boolean isLength = false;
                try {
                    length.set(n.image, this.ac);
                    isLength = true;
                }
                catch (Exception e) {
                    isLength = false;
                }
                if (isLength) {
                    this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.id_dim")), n.image);
                    s.addId(new IdSelector(n.image));
                    this.removeThisRule();
                } else {
                    try {
                        s.addId(new IdSelector(n.image));
                        this.ac.getFrame().addWarning("old_id");
                    }
                    catch (InvalidParamException e) {
                        this.ac.getFrame().addError(new CssError(e));
                        this.removeThisRule();
                    }
                }
            }
        } else {
            try {
                s.addId(new IdSelector(n.image));
            }
            catch (InvalidParamException e) {
                this.ac.getFrame().addError(new CssError(e));
                this.removeThisRule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CssProperty mediadeclaration() throws ParseException {
        CssExpression values = null;
        boolean important = false;
        this.setMediaDeclaration("on");
        try {
            String string_property = this.property();
            block5 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 50: {
                    this.jj_consume_token(50);
                    block19: while (true) {
                        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                            case 21: {
                                break;
                            }
                            default: {
                                this.jj_la1[97] = this.jj_gen;
                                break block19;
                            }
                        }
                        this.jj_consume_token(21);
                    }
                    values = this.expr();
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 64: {
                            important = this.prio();
                            break block5;
                        }
                    }
                    this.jj_la1[98] = this.jj_gen;
                    break;
                }
                default: {
                    this.jj_la1[99] = this.jj_gen;
                }
            }
            try {
                CssProperty p;
                this.setImportant(important);
                if (this.incompatible_error) {
                    throw new InvalidParamException("notforcss1", "inherit", this.ac);
                }
                CssProperty cssProperty = p = this.handleDeclaration(string_property.toLowerCase(), values, important);
                return cssProperty;
            }
            catch (InvalidParamException e2) {
                try {
                    this.incompatible_error = false;
                    if (null != values) {
                        values.starts();
                    }
                    this.addError((Exception)e2, values);
                    CssProperty e2 = null;
                }
                catch (NumberFormatException e3) {
                    this.skipAfterExpression(e3);
                    CssProperty cssProperty = null;
                    return cssProperty;
                }
                catch (ParseException e4) {
                    this.skipAfterExpression(e4);
                    CssProperty cssProperty = null;
                    return cssProperty;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                this.setMediaDeclaration("off");
                return e2;
            }
        }
        finally {
            this.setMediaDeclaration("off");
        }
    }

    public final CssProperty declaration() throws ParseException {
        boolean important = false;
        try {
            block15: {
                String string_property = this.property();
                this.jj_consume_token(50);
                block12: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[100] = this.jj_gen;
                            break block12;
                        }
                    }
                    this.jj_consume_token(21);
                }
                CssExpression values = this.expr();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 64: {
                        important = this.prio();
                        break;
                    }
                    default: {
                        this.jj_la1[101] = this.jj_gen;
                    }
                }
                try {
                    this.setImportant(important);
                    if (this.incompatible_error) {
                        throw new InvalidParamException("notforcss1", "inherit", this.ac);
                    }
                    if (values.getCount() == 0) break block15;
                    CssProperty p = this.handleDeclaration(string_property.toLowerCase(), values, important);
                    if (!values.end() && this.ac.getMedium() == null) {
                        this.addError((Exception)new InvalidParamException("unrecognize", "", this.ac), values);
                        break block15;
                    }
                    return p;
                }
                catch (InvalidParamException e) {
                    this.incompatible_error = false;
                    values.starts();
                    this.addError((Exception)e, values);
                }
            }
            return null;
        }
        catch (NumberFormatException e) {
            this.skipAfterExpression(e);
            return null;
        }
        catch (ParseException e) {
            this.skipAfterExpression(e);
            return null;
        }
        catch (NullPointerException e) {
            this.skipAfterExpression(e);
            return null;
        }
    }

    public final boolean prio() throws ParseException {
        this.jj_consume_token(64);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[102] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        return true;
    }

    public final CssExpression expr() throws ParseException {
        CssExpression values = new CssExpression();
        this.term(values);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 27: 
                case 29: 
                case 32: 
                case 34: 
                case 35: 
                case 41: 
                case 43: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 89: 
                case 92: {
                    break;
                }
                default: {
                    this.jj_la1[103] = this.jj_gen;
                    break block3;
                }
            }
            this.operator(values);
            this.term(values);
        }
        return values;
    }

    public final void term(CssExpression exp) throws ParseException {
        char operator = ' ';
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: 
            case 41: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 92: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 27: 
                    case 41: {
                        operator = this.unaryOperator();
                        break;
                    }
                    default: {
                        this.jj_la1[104] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 63: {
                        Token n = this.jj_consume_token(63);
                        this.setValue(new CssNumber(), exp, operator, n, 63);
                        break;
                    }
                    case 62: {
                        Token n = this.jj_consume_token(62);
                        this.setValue(new CssPercentage(), exp, operator, n, 62);
                        break;
                    }
                    case 53: {
                        Token n = this.jj_consume_token(53);
                        this.setValue(new CssLength(), exp, operator, n, 53);
                        break;
                    }
                    case 54: {
                        Token n = this.jj_consume_token(54);
                        this.setValue(new CssLength(), exp, operator, n, 54);
                        break;
                    }
                    case 55: {
                        Token n = this.jj_consume_token(55);
                        this.setValue(new CssLength(), exp, operator, n, 55);
                        break;
                    }
                    case 56: {
                        Token n = this.jj_consume_token(56);
                        this.setValue(new CssAngle(), exp, operator, n, 56);
                        break;
                    }
                    case 57: {
                        Token n = this.jj_consume_token(57);
                        this.setValue(new CssTime(), exp, operator, n, 57);
                        break;
                    }
                    case 58: {
                        Token n = this.jj_consume_token(58);
                        this.setValue(new CssFrequency(), exp, operator, n, 58);
                        break;
                    }
                    case 59: {
                        Token n = this.jj_consume_token(59);
                        this.setValue(new CssResolution(), exp, operator, n, 59);
                        break;
                    }
                    case 60: {
                        Token n = this.jj_consume_token(60);
                        this.setValue(new CssDate(), exp, operator, n, 60);
                        break;
                    }
                    case 61: {
                        Token n = this.jj_consume_token(61);
                        this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.unknown-dimension")), n.image);
                        break;
                    }
                    case 92: {
                        CssValue func = this.function();
                        this.setValue(func, exp, operator, null, 92);
                        break;
                    }
                    default: {
                        this.jj_la1[105] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[106] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            case 32: 
            case 34: 
            case 35: 
            case 52: 
            case 89: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 32: {
                        Token n = this.jj_consume_token(32);
                        this.setValue(new CssString(), exp, operator, n, 32);
                        break;
                    }
                    case 34: {
                        Token n = this.jj_consume_token(34);
                        Token t = this.getToken(1);
                        Token semicolon = new Token();
                        semicolon.kind = 42;
                        semicolon.image = ";";
                        if (t.kind == 50) {
                            this.addError((Exception)new ParseException(this.ac.getMsg().getString("parser.semi-colon")), (CssExpression)null);
                            this.rejectToken(semicolon);
                            break;
                        }
                        this.setValue(new CssIdent(), exp, operator, n, 34);
                        break;
                    }
                    case 35: {
                        this.hexcolor(exp);
                        break;
                    }
                    case 52: {
                        Token n = this.jj_consume_token(52);
                        CssURL _u = new CssURL();
                        _u.set(n.image, this.ac, this.url);
                        exp.addValue(_u);
                        break;
                    }
                    case 89: {
                        Token n = this.jj_consume_token(89);
                        this.setValue(new CssUnicodeRange(), exp, operator, n, 89);
                        break;
                    }
                    default: {
                        this.jj_la1[107] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 21: {
                            break;
                        }
                        default: {
                            this.jj_la1[108] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(21);
                }
            }
            default: {
                this.jj_la1[109] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final CssValue function() throws ParseException {
        CssColor color = new CssColor();
        ATSCColor colorATSC = new ATSCColor();
        Token n = this.jj_consume_token(92);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
        }
        CssExpression exp = this.expr();
        this.jj_consume_token(48);
        if (n.image.toLowerCase().equals("rgb(")) {
            if (!this.getAtRule().toString().equals("@media atsc-tv")) {
                color.setRGBColor(exp, this.ac);
                return color;
            }
            colorATSC.setRGBColor(exp, this.ac);
            return colorATSC;
        }
        if (n.image.toLowerCase().equals("atsc-rgba(")) {
            if (this.getAtRule().toString().equals("@media atsc-tv")) {
                colorATSC.setATSCrgba(exp, this.ac);
                return colorATSC;
            }
            this.addError((Exception)new InvalidParamException("onlyATSC", "", this.ac), this.getAtRule().toString());
            return null;
        }
        CssFunction f = new CssFunction();
        f.set(n.image.substring(0, n.image.length() - 1), exp);
        return f;
    }

    public final void hexcolor(CssExpression exp) throws ParseException {
        Token n = this.jj_consume_token(35);
        n.image = Util.strip(n.image);
        this.setValue(new CssColor(), exp, ' ', n, 35);
    }

    String skipStatement() throws ParseException {
        StringBuffer s = new StringBuffer();
        Token tok = this.getToken(0);
        boolean first = true;
        if (tok.image != null) {
            s.append(tok.image);
        }
        while (true) {
            try {
                tok = this.getToken(1);
                if (tok.kind == 0) {
                    if (!first) break;
                    return null;
                }
                s.append(tok.image);
                if (tok.kind == 26) {
                    this.getNextToken();
                    s.append(this.skip_to_matching_brace());
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                if (tok.kind == 36 || tok.kind == 42) {
                    this.getNextToken();
                    tok = this.getToken(1);
                    break;
                }
                this.getNextToken();
            }
            catch (TokenMgrError tokenerror) {
                try {
                    s.append(this.jj_input_stream.readChar());
                    continue;
                }
                catch (IOException ioex) {
                    return s.toString().trim();
                }
            }
            first = false;
        }
        while (tok.kind == 21) {
            this.getNextToken();
            tok = this.getToken(1);
        }
        String statement = s.toString().trim();
        return statement;
    }

    String skip_to_matching_brace() throws ParseException {
        StringBuffer s = new StringBuffer();
        int nesting = 1;
        while (true) {
            Token tok = this.getToken(1);
            if (tok.kind == 0) break;
            s.append(tok.image);
            if (tok.kind == 26) {
                ++nesting;
            } else if (tok.kind == 36 && --nesting == 0) break;
            this.getNextToken();
        }
        return s.toString();
    }

    void rejectToken(Token t) throws ParseException {
        Token fakeToken = new Token();
        t.next = this.token;
        fakeToken.next = t;
        this.token = fakeToken;
    }

    void skipAfterExpression(Exception e) throws ParseException {
        StringBuffer s = new StringBuffer();
        s.append(this.getToken((int)0).image);
        block4: while (true) {
            try {
                while (true) {
                    Token t = this.getToken(1);
                    if (t.kind == 26) {
                        s.append(t.image);
                        this.getNextToken();
                        s.append(this.skip_to_matching_brace());
                        this.getNextToken();
                        t = this.getToken(1);
                        continue;
                    }
                    if (t.kind == 42 || t.kind == 36 || t.kind == 0) break block4;
                    s.append(t.image);
                    this.getNextToken();
                    t = this.getToken(1);
                }
            }
            catch (TokenMgrError tmerr) {
                try {
                    s.append(this.jj_input_stream.readChar());
                }
                catch (IOException ioex) {
                    ioex.printStackTrace();
                    break;
                }
            }
        }
        String statement = s.toString().trim();
        this.addError(e, s.toString());
    }

    String convertStringIndex(String s, int start, int len, boolean escapeFirst) throws ParseException {
        int maxCount = 0;
        if (start == 0 && len == s.length() && s.indexOf(92) == -1) {
            return s;
        }
        StringBuilder buf = new StringBuilder(len);
        for (int index = start; index < len; ++index) {
            block18: {
                char c;
                block16: {
                    block17: {
                        c = s.charAt(index);
                        if (c != '\\') break block16;
                        if (++index >= len) break block17;
                        c = s.charAt(index);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': 
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': 
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                int t;
                                int numValue = Character.digit(c, 16);
                                int count = 1;
                                if (maxCount == 0) {
                                    int n = maxCount = this.ac.getCssVersion().equals("css1") ? 4 : 6;
                                }
                                while (index + 1 < len) {
                                    c = s.charAt(index + 1);
                                    t = Character.digit(c, 16);
                                    if (t != -1 && count++ < maxCount) {
                                        numValue = numValue << 4 | t;
                                        ++index;
                                        continue;
                                    }
                                    if (c == ' ' || c == '\t' || c == '\n' || c == '\f') {
                                        ++index;
                                        break;
                                    }
                                    if (c != '\r' || ++index + 1 >= len || s.charAt(index + 1) != '\n') break;
                                    ++index;
                                    break;
                                }
                                if (!escapeFirst && numValue < 255 && numValue > 31) {
                                    if (!(numValue > 96 && numValue < 123 || numValue > 64 && numValue < 91 || numValue > 47 && numValue < 58 || numValue == 95 || numValue == 45)) {
                                        buf.append('\\');
                                    }
                                    buf.append((char)numValue);
                                    break;
                                }
                                char[] b = new char[maxCount];
                                t = maxCount;
                                while (t > 0) {
                                    b[--t] = hexdigits[numValue & 0xF];
                                    numValue >>>= 4;
                                }
                                buf.append('\\').append(b);
                                break;
                            }
                            case '\n': 
                            case '\f': {
                                break;
                            }
                            case '\r': {
                                if (index + 1 < len && s.charAt(index + 1) == '\n') {
                                    ++index;
                                    break;
                                }
                                break block18;
                            }
                            case '-': 
                            case 'G': 
                            case 'H': 
                            case 'I': 
                            case 'J': 
                            case 'K': 
                            case 'L': 
                            case 'M': 
                            case 'N': 
                            case 'O': 
                            case 'P': 
                            case 'Q': 
                            case 'R': 
                            case 'S': 
                            case 'T': 
                            case 'U': 
                            case 'V': 
                            case 'W': 
                            case 'X': 
                            case 'Y': 
                            case 'Z': 
                            case '_': 
                            case 'g': 
                            case 'h': 
                            case 'i': 
                            case 'j': 
                            case 'k': 
                            case 'l': 
                            case 'm': 
                            case 'n': 
                            case 'o': 
                            case 'p': 
                            case 'q': 
                            case 'r': 
                            case 's': 
                            case 't': 
                            case 'u': 
                            case 'v': 
                            case 'w': 
                            case 'x': 
                            case 'y': 
                            case 'z': {
                                buf.append(c);
                                break;
                            }
                            default: {
                                buf.append('\\').append(c);
                                break;
                            }
                        }
                        break block18;
                    }
                    throw new ParseException("invalid string");
                }
                buf.append(c);
            }
            escapeFirst = false;
        }
        return buf.toString();
    }

    String convertIdent(String s) throws ParseException {
        return this.convertStringIndex(s, 0, s.length(), false);
    }

    String convertClassIdent(String s) throws ParseException {
        return this.convertStringIndex(s, 0, s.length(), true);
    }

    String convertString(String s) throws ParseException {
        return this.convertStringIndex(s, 0, s.length(), false);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0xE00000, 0xE00000, 0, 0x200000, 0x200000, 0, 0xC00000, 0xC00000, 0x200000, 0x200000, 0, 0x200000, 0x20000000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0, 0x20000000, 0x200000, Integer.MIN_VALUE, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0, 0, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x200000, 0x20000000, 0x200000, 0x20000000, 0x58000000, 0x200000, 0x200000, 1478492160, 0x8000000, 0x200000, 0x20000000, 0x200000, 0x200000, 0x200000, 0, 0, 0x200000, 0, 1478492160, 0x200000, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0x200000, 0x3000000, 0x200000, 0x200000, 0, 0x3000000, 0x200000, 0, 0x200000, 0, 0x200000, 0, 0, 0x200000, 0, 0, 0x200000, 0, 0x200000, 0x28000000, 0x8000000, 0, 0x200000, 0, 0x200000, 0x8000000, 0x200000};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 315404, 0, 0, 0, 0, 0x100001, 0, 0, 0, 4, 0, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 315404, 0, 0, 0, 0, 4, 262144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 2048, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 4, 1024, 0, 4, 0, 0, 0, 299016, 299016, 299016, 299016, 315404, 32768, 803209216, 16388, 0, 0, 480, 0, 0, 5, 480, 0, -2147483643, 0, 0, 0, 4, 262144, 0, 0, 262144, 0, 0, 0, -1046003, 512, -2097152, 0, 0x10000D, 0, -1048051, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0x60000000, 0x60000000, 4, 0, 0, 8, 0, 0, 67125746, 32768, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000002, 0, 0, 0, 0, 0, 0, 0, 0, 7680, 7680, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000002, 0x4000002, 0x4000002, 0x4000002, 0x4000002, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x18000000, 0, 0x18000000, 2, 0, 1, 0, 0, 1, 0, 0x12000000, 0, 0x10000000, 0, 0x2000000, 0, 0x12000000, 0};
    }

    public CssParser(InputStream stream) {
        this(stream, null);
    }

    public CssParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 111; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 111; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CssParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new CssParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 111; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 111; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public CssParser(CssParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 111; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(CssParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 111; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[95];
        for (i = 0; i < 95; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 111; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 95; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        CssParser.jj_la1_0();
        CssParser.jj_la1_1();
        CssParser.jj_la1_2();
    }
}

